/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.apple2e.SoftSwitches;
import jace.apple2e.Speaker;
import jace.config.ConfigurableField;
import jace.core.CPU;
import jace.core.Card;
import jace.core.Computer;
import jace.core.Device;
import jace.core.TimedDevice;
import jace.core.Video;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;

public class Motherboard
extends TimedDevice {
    static final Computer computer = Computer.getComputer();
    static final CPU cpu = computer.getCpu();
    static final Video video = computer.getVideo();
    static Motherboard instance;
    public static final Card[] cards;
    public static final Set<Device> miscDevices;
    @ConfigurableField(name="Enable Speaker", defaultValue="true")
    public static boolean enableSpeaker;
    private static Semaphore vblankTiming;
    public static Speaker speaker;
    public static long SPEED;
    static HashSet<Object> accelorationRequestors;

    static void vblankEnd() {
        vblankTiming.release();
        vblankTiming.acquireUninterruptibly();
        SoftSwitches.VBL.getSwitch().setState(false);
    }

    static void vblankStart() {
        vblankTiming.release();
        SoftSwitches.VBL.getSwitch().setState(true);
    }

    public static void waitForVBlank() {
        if (SoftSwitches.VBL.getState()) {
            return;
        }
        vblankTiming.acquireUninterruptibly();
        vblankTiming.release();
    }

    public Motherboard() {
        instance = this;
    }

    @Override
    protected String getDeviceName() {
        return "Motherboard";
    }

    @Override
    public void tick() {
        cpu.doTick();
        video.doTick();
        for (int i = 0; i < 7; ++i) {
            if (cards[i] == null) continue;
            cards[i].motherboardTick();
        }
        for (Device m : miscDevices) {
            if (!m.isRunning()) continue;
            m.doTick();
        }
    }

    @Override
    public long defaultCyclesPerSecond() {
        return SPEED;
    }

    @Override
    public void reconfigure() {
        boolean startAgain = this.isRunning();
        this.kill();
        accelorationRequestors.clear();
        super.reconfigure();
        if (enableSpeaker) {
            try {
                if (speaker == null || !Motherboard.speaker.lineAvailable) {
                    speaker = new Speaker();
                } else {
                    speaker.attach();
                }
                if (Motherboard.speaker.lineAvailable) {
                    miscDevices.add(speaker);
                }
            }
            catch (Throwable t) {
                System.out.println("Unable to initalize sound -- deactivating speaker out");
                speaker.detach();
                miscDevices.remove(speaker);
            }
        } else if (speaker != null) {
            speaker.detach();
            miscDevices.remove(speaker);
        }
        if (startAgain) {
            this.go();
        }
    }

    public static void requestSpeed(Object requester) {
        accelorationRequestors.add(requester);
        if (instance != null) {
            instance.enableTempMaxSpeed();
        }
    }

    public static void cancelSpeedRequest(Object requester) {
        accelorationRequestors.remove(requester);
        if (instance != null) {
            instance.disableTempMaxSpeed();
        }
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
        for (Device d : miscDevices) {
            d.suspend();
        }
        miscDevices.clear();
        this.kill();
    }

    static {
        cards = computer.getMemory().getAllCards();
        miscDevices = new HashSet<Device>();
        enableSpeaker = true;
        vblankTiming = new Semaphore(1, true);
        SPEED = 1020484L;
        accelorationRequestors = new HashSet();
    }
}

